var objRuleta;
var winningSegment;
var distnaciaX = 150;
var distnaciaY = 50;
var ctx;
var audio = new Audio('alarma.mp3');  // Create audio object and load desired file.
$(document).ready(function () {
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    leerElementos();
    llenarClientes();
    $('#listaClientes').select2();
    
    
});
function llenarClientes(){
    var lista = $("#listaClientes");
    var documento = $("#documento").val();
    $.ajax({
        type: "GET",
        url: baseURL + "/traerClientes",
        data: {documento: documento},
        dataType: "JSON",
        success: function (rs) {
            lista.html('');
            lista.append(
                '<option value="">Buscar Cliente</option>'
            );
            $(rs).each(function(key,value){
                lista.append(
                    '<option value="'+ value.id +'">'+ value.nombres +'</option>'
                );
            })
        }
    });
}

function seleccionar(){
    var cliente = $("#listaClientes").val();
    $("#buscador").css('display','none');
    $("#datosCliente").css('display','flex');
}
function comenzarJuego(){
    var cliente = $("#listaClientes").val();
    if(cliente != ''){
        $("#buscador").css('display','none');
        $("#ruleta").css('display','flex');
    }else{
        alert("Seleccione un cliente para continuar");
    }
}
function SonidoFinal()
{
    audio.pause();
    audio.currentTime = 0;
    audio.play();
}
function Mensaje() {
    var cliente = $("#listaClientes").val();
    winningSegment = objRuleta.getIndicatedSegment();
    SonidoFinal();
    swal({
        title: " ¡ "+winningSegment.text+" !",
    
        imageUrl: imgRuleta,
        showCancelButton: true,
        confirmButtonColor: "#e74c3c",
        confirmButtonText: "Entregar Premio",
        cancelButtonText: "Reinicar",
        closeOnConfirm: true,
        closeOnCancel: true
    },
    function (isConfirm) {
        if (isConfirm) {
            $.ajax({
                type: "POST",
                url: baseURL + '/registrarGanador',
                data: {cliente: cliente, premio: winningSegment.text},
                dataType: "JSON",
                success: function (rs) {
                    console.log(rs);
                    location.reload();
                }
            });
        } else {
            $('#ListaElementos').val($('#ListaElementos').val().replace(winningSegment.text,""));
            leerElementos();
            
        }
        objRuleta.stopAnimation(false);
        objRuleta.rotationAngle = 0;
        objRuleta.draw();
        // DibujarTriangulo();
        bigButton.disabled = false;
    });

}

function registrarGanador(cliente, premio){
    $.ajax({
        type: "POST",
        url: baseURL + '/registrarGanador',
        data: {cliente: cliente, premio: premio},
        dataType: "JSON",
        success: function (rs) {
            console.log(rs);
        }
    });
}

function DibujarTriangulo() {
    distnaciaX = 150;
    distnaciaY = 50;
    ctx = objRuleta.ctx;
    ctx.strokeStyle = 'navy';
    ctx.fillStyle = '#00cedb';
    ctx.lineWidth = 2;
    ctx.beginPath();
    ctx.moveTo(distnaciaX + 170, distnaciaY + 5);
    ctx.lineTo(distnaciaX + 230, distnaciaY + 5);
    ctx.lineTo(distnaciaX + 200, distnaciaY + 40);
    ctx.lineTo(distnaciaX + 171, distnaciaY + 5);
    ctx.stroke();
    ctx.fill();
}

function DibujarRuleta(ArregloElementos) {
    
    objRuleta = new Winwheel({
        'canvasId': 'Ruleta',
        'drawMode': 'image',
        'drawText': true,
        'textFillStyle' : '#ffffff',
        'lineWidth'   : 4,
        'numSegments': ArregloElementos.length,
        'imageOverlay' : true,
        'outerRadius': 220,
        'innerRadius': 65,
        'strokeStyle' : '#ffffff',
        'textStrokeStyle' : '#00cedb',
        'segments':ArregloElementos,
        'animation':
        {
            'type': 'spinToStop',
            'duration':4,
            'spins': 15,
            'callbackFinished': 'Mensaje()',
            // 'callbackAfter': 'DibujarTriangulo()' 
        }, 
        
    });

    // Create new image object in memory.
    let secondImg = new Image();
    
    // Create callback to execute once the image has finished loading.
    secondImg.onload = function()
    {
        objRuleta.wheelImage = secondImg;    // Make wheelImage equal the loaded image object.
        objRuleta.draw();                    // Also call draw function to render the wheel.
    }
    
    // Set the image source, once complete this will trigger the onLoad callback (above).
    secondImg.src = imgRuleta;

    // DibujarTriangulo();
}
function leerElementos() {
   
    $.ajax({
        type: "GET",
        url: baseURL + '/traerPremios',
        dataType: "JSON",
        success: function (rs) {
            console.log(rs);
            
            var ElementosRuleta= [];
            $(rs).each(function(key, value){
                ElementosRuleta.push({ 'text': value.nombre })
            });
            
            DibujarRuleta(ElementosRuleta);
        }
    });
        
} 